<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1;

use JMS\Serializer\Annotation as Serializer;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataStatusInterface;

/**
 * Class Status
 * @package Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1
 */
class Status implements ResponseDataStatusInterface
{
    /**
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("code")
     * @var int
     */
    private $code;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("message")
     * @var string|null
     */
    private $message;

    /**
     * @return int
     */
    public function getCode(): int
    {
        return $this->code;
    }

    /**
     * @return string|null
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }
}
