<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Worker\Wirecard;


use Lifestyle\PaymentServiceSdk\Exceptions\InvalidRequestVersionException;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Handler;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\RequestDataInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\ResponseDataInterface;

/**
 * Class PurchaseDebit
 * @package Lifestyle\PaymentServiceSdk\Worker\Wirecard
 */
class PurchaseDebit
{
    /**
     * @var Handler
     */
    private $handler;

    /**
     * PurchaseDebit constructor.
     * @param Handler $handler
     */
    public function __construct(Handler $handler)
    {
        $this->handler = $handler;
    }

    /**
     * @param RequestDataInterface $requestData
     * @param int $version
     * @return ResponseDataInterface
     * @throws InvalidRequestVersionException
     */
    public function chargeDebit(RequestDataInterface $requestData, int $version): ResponseDataInterface
    {
        return $this->handler->handle($requestData, $version);
    }
}
