<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Configuration;

use Lifestyle\PaymentServiceSdk\Configuration\ConfigModel;
use PHPUnit\Framework\TestCase;

/**
 * Class ConfigurationModelTest
 * @package Lifestyle\PaymentServiceSdk\Tests\Configuration
 */
class ConfigurationModelTest extends TestCase
{
    public function test_config_model()
    {
        $model = new ConfigModel('http://url', '12345678');
        $this->assertSame('http://url', $model->getServiceUrl());
        $this->assertSame('12345678', $model->getApiToken());
    }
}
