<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseCreditCard\Processor\Version1;

use JMS\Serializer\SerializerBuilder;
use Lifestyle\PaymentServiceSdk\Configuration\ConfigModel;
use Lifestyle\PaymentServiceSdk\Exceptions\InvalidRequestParametersException;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Processor\Version1\Processor;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\RequestDataInterface;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\Version1\Factory;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\Version1\RequestBuilder;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\ResponseDataInterface;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;
use Symfony\Component\Validator\Validation;

/**
 * Class ProcessorTest
 * @package Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseCreditCard\Processor\Version1
 */
class ProcessorTest extends TestCase
{

    public function test_process_credit_card_connection_time_out()
    {
        $factory = new Factory();
        $validator = Validation::createValidator();
        $requestBuilder = new RequestBuilder($factory, $validator);

        $configModel = new ConfigModel('urlnotfound', 'token');
        $serializer = SerializerBuilder::create()->build();

        $logger = $this->getMockBuilder(LoggerInterface::class)->getMock();
        $logger->method('error')->willReturn(true);

        $processor = new Processor($requestBuilder, $configModel, $serializer, $logger);
        $responseData = $processor->process($this->getRequestData());

        $this->assertInstanceOf(ResponseDataInterface::class, $responseData);
        $this->assertSame(400, $responseData->getCode());

    }

    /**
     * @throws InvalidRequestParametersException
     * @todo adjust url to test
     */
    public function test_process_credit_card_connection_forbidden()
    {
        $this->markTestSkipped('todo adjust url to test');
        $factory = new Factory();
        $validator = Validation::createValidator();
        $requestBuilder = new RequestBuilder($factory, $validator);

        $configModel = new ConfigModel('http://payment.service', 'fsdfsdf');
        $serializer = SerializerBuilder::create()->build();

        $processor = new Processor($requestBuilder, $configModel, $serializer);
        $responseData = $processor->process($this->getRequestData());

        $this->assertInstanceOf(ResponseDataInterface::class, $responseData);
        $this->assertSame(403, $responseData->getCode());
    }

    /**
     * @throws InvalidRequestParametersException
     * @todo adjust url to test
     */
    public function test_process_credit_card_connection_400()
    {
        $this->markTestSkipped('todo adjust url to test');
        $factory = new Factory();
        $validator = Validation::createValidator();
        $requestBuilder = new RequestBuilder($factory, $validator);

        $configModel = new ConfigModel('http://payment.service', '1234567');
        $serializer = SerializerBuilder::create()->build();

        $processor = new Processor($requestBuilder, $configModel, $serializer);
        $responseData = $processor->process($this->getRequestData());

        $this->assertInstanceOf(ResponseDataInterface::class, $responseData);
        $this->assertSame(400, $responseData->getCode());
    }

    /**
     * @return RequestDataInterface
     */
    private function getRequestData(): RequestDataInterface
    {
        $requestData = new RequestData();
        $requestData->setTokenId(4304509873471003);
        $requestData->setAmount(11.11);
        $requestData->setCurrency('EUR');
        $requestData->setClient('vto');
        $requestData->setFirstName('Alan');
        $requestData->setLastName('Turing');
        $requestData->setProcessNumber('My Process Number');

        $customField = new CustomField();
        $customField->setName('myCustomName');
        $customField->setValue('myCustomValue');

        $requestData->addCustomField($customField);

        return $requestData;
    }
}
