<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseCreditCard\Processor\Version1;

use Doctrine\Common\Collections\ArrayCollection;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Request\RequestDataInterface;

/**
 * Class RequestDataTest
 * @package Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseCreditCard\Processor\Version1
 */
class RequestData implements RequestDataInterface
{
    /**
     * @var string|null
     */
    private $firstName;

    /**
     * @var string|null
     */
    private $lastName;

    /**
     * @var string|null
     */
    private $processNumber;

    /**
     * @var integer|null
     */
    private $tokenId;

    /**
     * @var float|null
     */
    private $amount;

    /**
     * @var string|null
     */
    private $currency;

    /**
     * @var string|null
     */
    private $client;

    /**
     * @var ArrayCollection|null|CustomField[]
     */
    private $customFields;

    /**
     * @return string|null
     */
    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    /**
     * @param string|null $firstName
     */
    public function setFirstName(?string $firstName): void
    {
        $this->firstName = $firstName;
    }

    /**
     * @return string|null
     */
    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    /**
     * @param string|null $lastName
     */
    public function setLastName(?string $lastName): void
    {
        $this->lastName = $lastName;
    }

    /**
     * @return string|null
     */
    public function getProcessNumber(): ?string
    {
        return $this->processNumber;
    }

    /**
     * @param string|null $processNumber
     */
    public function setProcessNumber(?string $processNumber): void
    {
        $this->processNumber = $processNumber;
    }

    /**
     * @return int|null
     */
    public function getTokenId(): ?int
    {
        return $this->tokenId;
    }

    /**
     * @param int|null $tokenId
     */
    public function setTokenId(?int $tokenId): void
    {
        $this->tokenId = $tokenId;
    }

    /**
     * @return float|null
     */
    public function getAmount(): ?float
    {
        return $this->amount;
    }

    /**
     * @param float|null $amount
     */
    public function setAmount(?float $amount): void
    {
        $this->amount = $amount;
    }

    /**
     * @return string|null
     */
    public function getCurrency(): ?string
    {
        return $this->currency;
    }

    /**
     * @param string|null $currency
     */
    public function setCurrency(?string $currency): void
    {
        $this->currency = $currency;
    }

    /**
     * @return string|null
     */
    public function getClient(): ?string
    {
        return $this->client;
    }

    /**
     * @param string|null $client
     */
    public function setClient(?string $client): void
    {
        $this->client = $client;
    }

    /**
     * @return ArrayCollection|CustomField[]|null
     */
    public function getCustomFields(): ?ArrayCollection
    {
        return $this->customFields;
    }

    /**
     * @param CustomField $customField
     */
    public function addCustomField(CustomField $customField): void
    {
        if (null === $this->customFields) {
            $this->customFields = new ArrayCollection();
        }

        if (!$this->customFields->contains($customField)) {
            $this->customFields->add($customField);
        }
    }
}
