<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseCreditCard\Response\Version1;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\SerializerBuilder;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseCreditCard\Response\Version1\Response;
use PHPUnit\Framework\TestCase;

/**
 * Class ResponseTest
 * @package App\Tests\Services\Wirecard\Purchase\Response
 */
class ResponseTest extends TestCase
{
    public function test_response_model()
    {
        $serializer = SerializerBuilder::create()->build();

        /** @var Response $xmlResponse */
        $xmlResponse = $serializer->deserialize($this->getXmlString(), Response::class, 'xml');

        //also test the getter
        $this->assertEquals(200, $xmlResponse->getCode());
        $this->assertEquals('OK', $xmlResponse->getStatus());
        $this->assertEquals('Token Id generated', $xmlResponse->getMessage());
        $this->assertEquals('4acder45g', $xmlResponse->getTrackId());
        $this->assertEquals(2.04, $xmlResponse->getScriptTimeSec());

        $this->assertEquals('Alan', $xmlResponse->getAccountHolder()->getFirstName());
        $this->assertEquals('Turing', $xmlResponse->getAccountHolder()->getLastName());
        $this->assertEquals(1111111111, $xmlResponse->getCardToken()->getTokenId());
        $this->assertEquals('1234*******34345', $xmlResponse->getCardToken()->getMaskedAccountNumber());

        /** @var Response $jsonResponse */
        $jsonResponse = $serializer->deserialize($this->getJsonString(), Response::class, 'json');

        //also test the getter
        $this->assertEquals(200, $jsonResponse->getCode());
        $this->assertEquals('OK', $jsonResponse->getStatus());
        $this->assertEquals('Token Id generated', $jsonResponse->getMessage());
        $this->assertEquals('4acder45g', $jsonResponse->getTrackId());
        $this->assertEquals(2.04, $jsonResponse->getScriptTimeSec());

        $this->assertEquals('Alan', $jsonResponse->getAccountHolder()->getFirstName());
        $this->assertEquals('Turing', $jsonResponse->getAccountHolder()->getLastName());
        $this->assertEquals(1111111111, $jsonResponse->getCardToken()->getTokenId());
        $this->assertEquals('1234*******34345', $jsonResponse->getCardToken()->getMaskedAccountNumber());

        $this->assertInstanceOf(ArrayCollection::class, $jsonResponse->getStatuses());
        $this->assertEquals('4004', $jsonResponse->getStatuses()->first()->getCode());
        $this->assertEquals('The resource was successfully created.',
            $jsonResponse->getStatuses()->first()->getMessage());
    }

    /**
     * @return string
     */
    private function getXmlString(): string
    {
        return '<?xml version="1.0"?>
                <purchaseResponse>
                  <code>200</code>
                  <status>OK</status>
                  <message>Token Id generated</message>
                  <trackId>4acder45g</trackId>
                  <scriptTimeSec>2.04</scriptTimeSec>
                  <accountHolder>
                    <firstName>Alan</firstName>
                    <lastName>Turing</lastName>
                  </accountHolder>
                  <cardToken>
                    <tokenId>1111111111</tokenId>
                    <maskedAccountNumber>1234*******34345</maskedAccountNumber>
                  </cardToken>
                </purchaseResponse>';
    }

    /**
     * @return string
     */
    private function getJsonString(): string
    {
        return '{
                "code": 200,
                "status": "OK",
                "message": "Token Id generated",
                "trackId": "4acder45g",
                "scriptTimeSec": 2.04,
                "accountHolder": {
                    "firstName": "Alan",
                    "lastName": "Turing"
                },
                "cardToken": {
                    "tokenId": 1111111111,
                    "maskedAccountNumber": "1234*******34345"
                },
                "statuses": [
                    {
                     "code": 4004,
                     "message": "The resource was successfully created."
                    }
                ]
            }';
    }
}
