<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2020 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Response\Version1;

use Doctrine\Common\Collections\ArrayCollection;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1\Response;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1\AccountHolder;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1\BankAccount;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1\Mandate;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Response\Version1\Periodic;
use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;

/**
 * Class ResponseTest
 * @package Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Response\Version1
 */
class ResponseTest extends TestCase
{
    public function test_response_model()
    {
        $serializer = SerializerBuilder::create()->build();

        /**
         * @var Response $xmlResponse
         */
        $xmlResponse = $serializer->deserialize($this->getXmlString(), Response::class, 'xml');

        //also test the getter
        $this->assertEquals(200, $xmlResponse->getCode());
        $this->assertEquals('OK', $xmlResponse->getStatus());
        $this->assertEquals('Token Id generated', $xmlResponse->getMessage());
        $this->assertEquals('4acder45g', $xmlResponse->getTrackId());
        $this->assertEquals(2.04, $xmlResponse->getScriptTimeSec());

        $this->assertInstanceOf(AccountHolder::class, $xmlResponse->getAccountHolder());

        /**
         * @var Response $jsonResponse
         */
        $jsonResponse = $serializer->deserialize($this->getJsonString(), Response::class, 'json');

        //also test the getter
        $this->assertEquals(200, $jsonResponse->getCode());
        $this->assertEquals('OK', $jsonResponse->getStatus());
        $this->assertEquals('Token Id generated', $jsonResponse->getMessage());
        $this->assertEquals('4acder45g', $jsonResponse->getTrackId());
        $this->assertEquals(2.04, $jsonResponse->getScriptTimeSec());
        $this->assertEquals('processNumber', $jsonResponse->getProcessNumber());
        $this->assertEquals('transactionId', $jsonResponse->getTransactionId());
        $this->assertEquals('requestId', $jsonResponse->getRequestId());
        $this->assertEquals('merchantAccountId', $jsonResponse->getMerchantAccountId());
        $this->assertEquals('parentTransactionId', $jsonResponse->getParentTransactionId());
        $this->assertEquals('transactionType', $jsonResponse->getTransactionType());
        $this->assertEquals('paymentMethodsName', $jsonResponse->getPaymentMethodsName());
        $this->assertEquals('creditorId', $jsonResponse->getCreditorId());
        $this->assertEquals('dueDate', $jsonResponse->getDueDate());
        $this->assertEquals('apiId', $jsonResponse->getApiId());
        $this->assertEquals('locale', $jsonResponse->getLocale());
        $this->assertEquals('providerTransactionReferenceId', $jsonResponse->getProviderTransactionReferenceId());
        $this->assertEquals('currency', $jsonResponse->getCurrency());
        $this->assertEquals('descriptor', $jsonResponse->getDescriptor());
        $this->assertEquals('authorizationCode', $jsonResponse->getAuthorizationCode());
        $this->assertEquals(999, $jsonResponse->getAmount());

        $this->assertInstanceOf(AccountHolder::class, $jsonResponse->getAccountHolder());
        $this->assertEquals('Alan', $jsonResponse->getAccountHolder()->getFirstName());
        $this->assertEquals('Turing', $jsonResponse->getAccountHolder()->getLastName());

        $this->assertInstanceOf(BankAccount::class, $jsonResponse->getBankAccount());
        $this->assertEquals('iban', $jsonResponse->getBankAccount()->getIban());
        $this->assertEquals('bic', $jsonResponse->getBankAccount()->getBic());

        $this->assertInstanceOf(Mandate::class, $jsonResponse->getMandate());
        $this->assertEquals('mandateId', $jsonResponse->getMandate()->getMandateId());
        $this->assertEquals('signedDate', $jsonResponse->getMandate()->getSignedDate());

        $this->assertInstanceOf(Periodic::class, $jsonResponse->getPeriodic());
        $this->assertEquals('periodicType', $jsonResponse->getPeriodic()->getPeriodicType());
        $this->assertEquals('sequenceType', $jsonResponse->getPeriodic()->getSequenceType());

        $this->assertInstanceOf(ArrayCollection::class, $jsonResponse->getCustomFields());
        $this->assertEquals('flight', $jsonResponse->getCustomFields()->first()->getName());
        $this->assertEquals('23233434344', $jsonResponse->getCustomFields()->first()->getValue());

        $this->assertInstanceOf(ArrayCollection::class, $jsonResponse->getStatuses());
        $this->assertEquals('4004', $jsonResponse->getStatuses()->first()->getCode());
        $this->assertEquals('The resource was successfully created.',
            $jsonResponse->getStatuses()->first()->getMessage());
    }

    /**
     * @return string
     */
    private function getJsonString(): string
    {
        return '{
                    "code": 200,
                    "status": "OK",
                    "message": "Token Id generated",
                    "trackId": "4acder45g",
                    "scriptTimeSec": 2.04,
                    "processNumber": "processNumber",
                    "transactionId": "transactionId",
                    "requestId": "requestId",
                    "merchantAccountId": "merchantAccountId",
                    "parentTransactionId": "parentTransactionId",
                    "transactionType": "transactionType",
                    "paymentMethodsName": "paymentMethodsName",
                    "creditorId": "creditorId",
                    "dueDate": "dueDate",
                    "apiId": "apiId",
                    "locale": "locale",
                    "providerTransactionReferenceId": "providerTransactionReferenceId",
                    "currency": "currency",
                    "descriptor": "descriptor",
                    "authorizationCode": "authorizationCode",
                    "amount": 999,
                    "accountHolder": {
                        "firstName": "Alan",
                        "lastName": "Turing"
                    },
                    "bankAccount": {
                        "iban": "iban",
                        "bic": "bic"
                    },
                    "mandate": {
                        "mandateId": "mandateId",
                        "signedDate": "signedDate"
                    },
                    "periodic": {
                        "periodicType": "periodicType",
                        "sequenceType": "sequenceType"
                    },
                    "customFields": [
                        {
                         "name": "flight",
                         "value": "23233434344"
                        }
                    ],
                    "statuses": [
                        {
                         "code": 4004,
                         "message": "The resource was successfully created."
                        }
                    ]
                }';
    }

    /**
     * @return string
     */
    private function getXmlString(): string
    {
        return '<?xml version="1.0"?>
                <purchaseDebitResponse>
                  <code>200</code>
                  <status>OK</status>
                  <message>Token Id generated</message>
                  <trackId>4acder45g</trackId>
                  <scriptTimeSec>2.04</scriptTimeSec>
                  <accountHolder>
                    <firstName>Alan</firstName>
                    <lastName>Turing</lastName>
                  </accountHolder>
                  <bankAccount>
                    <iban>iban</iban>
                    <bic>bic</bic>
                  </bankAccount>
                </purchaseDebitResponse>';
    }
}
