<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\DependencyInjection;

use Exception;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\Config\FileLocator;
use Lifestyle\PaymentServiceSdk\Configuration\ConfigModel;

/**
 * Class LifestylePaymentServiceSdkExtension
 * @package Lifestyle\PaymentServiceSdk\DependencyInjection
 */
class LifestylePaymentServiceSdkExtension extends Extension
{
    /**
     * @param array $configs
     * @param ContainerBuilder $container
     * @throws Exception
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator([__DIR__ . '/../Resources/config/']));
        $loader->load('services.yml');

        $this->configConfiguration($config, $container);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     * @throws ServiceNotFoundException
     */
    private function configConfiguration(array $config, ContainerBuilder $container)
    {
        $serviceId = ConfigModel::class;
        $definition = $container->findDefinition($serviceId);
        $definition->setArguments([
            $config['url'],
            $config['api_token'],
        ]);
    }
}
