<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Request\Version1;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Lifestyle\PaymentServiceSdk\Services\Wirecard\PurchaseDebit\Request\RequestDataInterface;

/**
 * Class RequestData
 * @package Lifestyle\PaymentServiceSdk\Tests\Services\Wirecard\PurchaseDebit\Request\Version1
 */
class RequestData implements RequestDataInterface
{
    /**
     * @inheritDoc
     */
    public function getFirstName(): ?string
    {
        return 'Alan';
    }

    /**
     * @inheritDoc
     */
    public function getLastName(): ?string
    {
        return 'Turing';
    }

    /**
     * @inheritDoc
     */
    public function getProcessNumber(): ?string
    {
        return 'processNo';
    }

    /**
     * @inheritDoc
     */
    public function getAmount(): ?float
    {
        return 1.99;
    }

    /**
     * @inheritDoc
     */
    public function getCurrency(): ?string
    {
        return 'EUR';
    }

    /**
     * @inheritDoc
     */
    public function getClient(): ?string
    {
        return 'vto';
    }

    /**
     * @inheritDoc
     */
    public function getCreditorId(): ?string
    {
        return 'creditorId';
    }

    /**
     * @inheritDoc
     */
    public function getPaymentMethod(): ?string
    {
        return 'paymentMethod';
    }

    /**
     * @inheritDoc
     */
    public function getDescriptor(): ?string
    {
        return 'descriptor';
    }

    /**
     * @inheritDoc
     */
    public function getMandateId(): ?string
    {
        return 'mandateId';
    }

    /**
     * @inheritDoc
     */
    public function getMandateSignedDate(): ?DateTime
    {
        return new DateTime();
    }

    /**
     * @inheritDoc
     */
    public function getPeriodicType(): ?string
    {
        return 'periodicType';
    }

    /**
     * @inheritDoc
     */
    public function getSequenceType(): ?string
    {
        return 'sequenceType';
    }

    /**
     * @inheritDoc
     */
    public function getIban(): ?string
    {
        return 'iban';
    }

    /**
     * @inheritDoc
     */
    public function getBic(): ?string
    {
        return 'bic';
    }

    /**
     * @inheritDoc
     */
    public function getCustomFields(): ?ArrayCollection
    {
        return new ArrayCollection([new RequestDataCustomField()]);
    }

    /**
     * @inheritDoc
     */
    public function getParentTransactionId(): ?string
    {
        return '1234456';
    }
}
