<?php

/**
 * Class MappingHandlerPass
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\Pimcore\ExportBundle\Exception\InvalidMappingHandlerDetectedException;
use Lifestyle\Pimcore\ExportBundle\Mapping\Handler\HandlerInterface;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class MappingHandlerPass
 * @package Lifestyle\Pimcore\ExportBundle\Compiler
 */
class MappingHandlerPass implements CompilerPassInterface
{
    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        $this->addMappingHandler($container);
    }

    /**
     * @param ContainerBuilder $container
     * @throws InvalidMappingHandlerDetectedException
     */
    private function addMappingHandler(ContainerBuilder $container)
    {
        if (!$container->has('lifestyle_pimcore_export.mapping.context')) {
            return;
        }

        $definition = $container->findDefinition(
            'lifestyle_pimcore_export.mapping.context'
        );

        $taggedServices = $container->findTaggedServiceIds(
            'lifestyle_pimcore_export.mapping_handler'
        );

        foreach ($taggedServices as $id => $tags) {

            $serviceDefinition = $container->findDefinition($id);
            if (!is_subclass_of($serviceDefinition->getClass(), HandlerInterface::class)) {
                throw new InvalidMappingHandlerDetectedException(
                    sprintf("Mapping handler %s must implement interface %s", $serviceDefinition->getClass(), HandlerInterface::class)
                );
            }

            $definition->addMethodCall(
                'addHandler',
                array(new Reference($id))
            );
        }
    }
}
