<?php

/**
 * Class LifestylePimcoreExportBundle
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle;

use Lifestyle\Pimcore\ExportBundle\Compiler\ExportHandlerPass;
use Pimcore\Extension\Bundle\AbstractPimcoreBundle;
use Lifestyle\Pimcore\ExportBundle\Compiler\MappingHandlerPass;
use Lifestyle\Pimcore\ExportBundle\Compiler\ObjectMapperPass;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class LifestylePimcoreExportBundle
 *
 * @package Lifestyle\Pimcore\ExportBundle
 */
class LifestylePimcoreExportBundle extends AbstractPimcoreBundle
{
    public function build(ContainerBuilder $container)
    {
        $container->addCompilerPass(new MappingHandlerPass());
        $container->addCompilerPass(new ObjectMapperPass());
        $container->addCompilerPass(new ExportHandlerPass());
    }

    /**
     * getDescription
     *
     * @return string
     */
    public function getDescription()
    {
        return 'Object data mapping and controlling of the export';
    }
}
