<?php

/**
 * Class DataCollector
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector;

/**
 * Class DataCollector
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector
 */
class DataCollector implements DataCollectorInterface
{
    /**
     * @var array|DataCollectorItemInterface[]|DataCollectorItemTranslatableInterface[]
     */
    private $items = [];

    /**
     * @param string $name
     * @param mixed $value
     */
    public function addItem($name, $value)
    {
        if (!$this->hasItem($name)) {
            $this->items[$name] = new DataCollectorItem($name, $value);
        }
    }

    /**
     * @return array
     */
    public function getCollectedLocales()
    {
        $locales = [];

        foreach ($this->items as $item) {
            if ($item->isTranslatable()) {
                $locales = array_merge($locales, $item->getLocales());
            }
        }

        return array_unique($locales);
    }

    /**
     * @param string $name
     * @return DataCollectorItemInterface|DataCollectorItemTranslatableInterface|mixed
     */
    public function addTranslatableItem($name)
    {
        if (!$this->hasItem($name)) {
            $this->items[$name] = new DataCollectorTranslatableItem($name);
        }
        return $this->items[$name];
    }

    /**
     * @return array|DataCollectorItemInterface[]|DataCollectorItemTranslatableInterface[]
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * @param string $key
     * @return DataCollectorItemInterface|DataCollectorItemTranslatableInterface|mixed|null
     */
    public function getItem($key)
    {
        return $this->hasItem($key) ? $this->items[$key] : null;
    }

    /**
     * @param string $key
     * @return mixed|null
     */
    public function getItemValue($key)
    {
        return $this->hasItem($key) ? $this->items[$key]->getValue() : null;
    }

    /**
     * @param string $key
     * @return bool
     */
    public function hasItem($key)
    {
        return array_key_exists($key, $this->items);
    }

    public function removeItem($key)
    {
        unset($this->items[$key]);
    }
}
