<?php

/**
 * Interface DataCollectorInterface
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector;

/**
 * Interface DataCollectorInterface
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector
 */
interface DataCollectorInterface
{
    /**
     * @return DataCollectorItemInterface[]|array
     */
    public function getItems();

    /**
     * @param string $key
     * @return DataCollectorItemInterface|DataCollectorItemTranslatableInterface|null
     */
    public function getItem($key);

    /**
     * @param string $key
     * @return mixed|null
     */
    public function getItemValue($key);

    /**
     * @param string $name
     * @param mixed $value
     */
    public function addItem($name, $value);

    /**
     * @param string $name
     * @return DataCollectorTranslatableItem
     */
    public function addTranslatableItem($name);

    /**
     * @return array
     */
    public function getCollectedLocales();

    /**
     * @param string $key
     * @return bool
     */
    public function hasItem($key);
}
