<?php

/**
 * Class DataCollectorTranslatableItem
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector;

/**
 * Class DataCollectorTranslatableItem
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector
 */
class DataCollectorTranslatableItem implements DataCollectorItemInterface, DataCollectorItemTranslatableInterface
{

    /**
     * @var string
     */
    private $name;

    /**
     * @var array
     */
    private $values;

    /**
     * DataCollectorItem constructor.
     * @param string $name
     */
    public function __construct($name)
    {
        $this->name = $name;
    }

    /**
     * @param mixed $value
     * @param string $locale
     */
    public function addValue($value, $locale)
    {
        $this->values[$locale] = $value;
    }

    /**
     * @return bool
     */
    public function isTranslatable()
    {
        return true;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string|null $locale
     * @return mixed
     */
    public function getValue($locale = null)
    {
        if (null === $locale) {
            return null;
        }

        return array_key_exists($locale, $this->values) ? $this->values[$locale] : null;
    }

    /**
     * @return array
     */
    public function getLocales()
    {
        return array_keys($this->values);
    }
}
