<?php

/**
 * Class ProductMapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\ObjectMapper;

use Pimcore\Model\DataObject\Channel;
use Pimcore\Model\DataObject\Product;
use Lifestyle\Pimcore\ExportBundle\Exception\NoHandlerException;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollector;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;
use Pimcore\Model\DataObject\Taxon;

/**
 * Class ProductMapper
 *
 * @package Lifestyle\Pimcore\ExportBundle\Mapper
 */
class ProductMapper extends MapperAbstract
{
    /**
     * @param $object
     * @return bool
     */
    public function applicable($object)
    {
        return $object instanceof Product || $object instanceof Channel || $object instanceof Taxon;
    }

    /**
     * @param \Pimcore\Model\DataObject\Product $object
     * @return DataCollectorInterface
     */
    public function getUpdateDataCollector($object)
    {
        $config = \Pimcore\Config::getSystemConfig();
        $languages = explode(',', $config->general->validLanguages);

        $collector = $this->createDataCollectorFromProduct($object);

        foreach ($languages as $lang) {

            /**
             * @var \Pimcore\Model\DataObject\ClassDefinition\Data[] $property
             */
            foreach ($object->getClass()->getFieldDefinitions() as $property) {
                try {
                    $this->apiManager->getMappingProcessor()->handle($collector, $object, $property, $lang);
                } catch (NoHandlerException $nhe) {
                    // $this->apiManager;
                }
            }
        }

        return $collector;
    }

    /**
     * @param \Pimcore\Model\DataObject\Product $object
     * @return DataCollectorInterface
     */
    public function getDeleteDataCollector($object)
    {
        return $this->createDataCollectorFromProduct($object);
    }

    /**
     * @param \Pimcore\Model\DataObject\Concrete $object
     * @return DataCollector
     */
    private function createDataCollectorFromProduct($object)
    {
        $collector = new DataCollector();
        $collector->addItem('id', $object->getId());
        $collector->addItem('className', $object->getClassName());
        $collector->addItem('parentId', $object->getParentId());
        $collector->addItem('parentClassName', $object->getValueFromParent('className'));

        return $collector;
    }
}
