<?php

/**
 * Class MappingHandlerPassTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\Pimcore\ExportBundle\Compiler\MappingHandlerPass;
use Lifestyle\Pimcore\ExportBundle\Exception\InvalidMappingHandlerDetectedException;
use Lifestyle\Pimcore\ExportBundle\Mapping\Context;
use Lifestyle\Pimcore\ExportBundle\Mapping\Handler\HandlerInterface;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class MappingHandlerPassTest
 * @package Tests\Lifestyle\Pimcore\ExportBundle\Compiler
 */
class MappingHandlerPassTest extends TestCase
{
    public function testBaseDefinitionNotFound()
    {
        $container = new ContainerBuilder();

        $pass = new MappingHandlerPass();
        $this->assertNull($pass->process($container));
    }

    public function testNoTaggedServices()
    {
        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.mapping.context')
            ->setClass(Context::class);

        $pass = new MappingHandlerPass();
        $pass->process($container);

        $context = $container->get('lifestyle_pimcore_export.mapping.context');
        $this->assertAttributeCount(0, 'handlers', $context);
    }

    public function testTaggedServicesWillBeAdded()
    {
        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.mapping.context')
            ->setClass(Context::class);

        $container
            ->register('handler.foo')
            ->setClass($this->getMockBuilder(HandlerInterface::class)->getMock())
            ->addTag('lifestyle_pimcore_export.mapping_handler')
            ->setPublic(false);

        $container
            ->register('handler.bar')
            ->setClass($this->getMockBuilder(HandlerInterface::class)->getMock())
            ->addTag('lifestyle_pimcore_export.mapping_handler')
            ->setPublic(false);

        $pass = new MappingHandlerPass();
        $pass->process($container);

        $context = $container->get('lifestyle_pimcore_export.mapping.context');

        $reflector = new \ReflectionClass($context);
        $property = $reflector->getProperty('handlers');
        $property->setAccessible(true);

        foreach ($property->getValue($context) as $priority => $handlers) {

            $this->assertCount(2, $handlers);

            foreach ($handlers as $handler) {
                $this->assertTrue(is_object($handler));
            }
        }
    }

    public function testProcessWillThrowMissingInterfaceException()
    {
        $this->expectException(InvalidMappingHandlerDetectedException::class);

        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.mapping.context')
            ->setClass(Context::class);

        $container
            ->register('handler.foo')
            ->addTag('lifestyle_pimcore_export.mapping_handler')
            ->setPublic(false);

        $pass = new MappingHandlerPass();
        $pass->process($container);
    }
}
