<?php

/**
 * Class Object
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Listener;

use Pimcore\Event\Model\DataObjectEvent;
use Pimcore\Model\Element\ValidationException;
use Psr\Log\LoggerInterface;
use Lifestyle\Pimcore\ExportBundle\ObjectMapper\Handler;
use Symfony\Component\VarDumper\Cloner\VarCloner;
use Symfony\Component\VarDumper\Dumper\CliDumper;
use Symfony\Component\VarDumper\VarDumper;

/**
 * Class Object
 *
 * @package Lifestyle\Pimcore\ExportBundle\Action
 */
class Object
{
    /**
     * @var \Pimcore\Log\ApplicationLogger|LoggerInterface
     */
    private $logger;

    /**
     * @var Handler
     */
    private $objectMapper;

    /**
     * Object constructor.
     * @param LoggerInterface $logger
     * @param Handler $objectMapper
     * @throws ValidationException
     */
    public function __construct(LoggerInterface $logger, Handler $objectMapper)
    {
        $this->objectMapper = $objectMapper;
        $this->logger = $logger;

        VarDumper::setHandler(function ($var) use ($logger) {

            $cloner = new VarCloner();
            $dumper = new CliDumper();
            $output = fopen('php://memory', 'r+b');

            $dumper->dump($cloner->cloneVar($var), $output);
            $logger->debug(stream_get_contents($output, -1, 0));
        });
    }

    /**
     * onPostUpdate
     *
     * @param DataObjectEvent $event
     * @throws ValidationException
     */
    public function onPostUpdate(DataObjectEvent $event)
    {
        try {

            $this->objectMapper->update($event);

        } catch (\Exception $exception) {
            $this->logger->error($exception->getMessage());
            throw new ValidationException($exception->getMessage());
        }
    }

    /**
     * onPostDelete
     *
     * @param DataObjectEvent $event
     * @throws ValidationException
     */
    public function onPostDelete(DataObjectEvent $event)
    {
        try {

            $this->objectMapper->delete($event);

        } catch (\Exception $exception) {
            $this->logger->error($exception->getMessage());
            throw new ValidationException($exception->getMessage());
        }
    }
}
