<?php

/**
 * Interface DataCollectorInterface
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector;

/**
 * Interface DataCollectorInterface
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector
 */
interface DataCollectorInterface
{
    /**
     * @param string $key
     * @param mixed $value
     * @param string|null $locale
     */
    public function addItem($key, $value, $locale = null);

    /**
     * @param $key
     * @param null $locale
     * @return bool
     */
    public function hasItem($key, $locale = null);

    /**
     * @param string $key
     * @param string|null $locale
     * @return DataCollectorItemInterface|null
     */
    public function getItem($key, $locale = null);

    /**
     * @param string $key
     * @param string|null $locale
     * @return mixed|null
     */
    public function getItemValue($key, $locale = null);

    /**
     * @param string|null $locale
     * @return DataCollectorItemInterface[]
     */
    public function getItems($locale = null);

    /**
     * Get array with unique locales as values
     *
     * @return array
     */
    public function getCollectedLocales();
}
