<?php

/**
 * Class DataCollectorItem
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector;

/**
 * Class DataCollectorItem
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector
 */
class DataCollectorItem implements DataCollectorItemInterface
{
    /**
     * @var string
     */
    private $key;

    /**
     * @var mixed
     */
    private $value;

    /**
     * @var string
     */
    private $locale;

    /**
     * CollectorItem constructor.
     * @param string $key
     * @param mixed $value
     * @param string $locale
     */
    public function __construct($key, $value, $locale = null)
    {
        $this->key = $key;
        $this->value = $value;
        $this->locale = $locale;
    }

    /**
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return string
     */
    public function getLocale()
    {
        return $this->locale;
    }

    /**
     * @return bool
     */
    public function hasLocale()
    {
        return null !== $this->locale;
    }
}
