<?php

/**
 * Class LocalizedFieldHandler
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Handler;

use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Localizedfields;
use Pimcore\Model\DataObject\Concrete;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;

/**
 * Class LocalizedFieldHandler
 *
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Handler
 */
class LocalizedFieldHandler implements HandlerInterface
{
    /**
     * handle
     *
     * @param Data $property
     *
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof Localizedfields;
    }

    /**
     * handles
     *
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        /** @var \Pimcore\Model\DataObject\ClassDefinition\Data\Localizedfields $property */

        // Retrieve first localized fields block
        foreach ($property->getChildren() as $field) {
            $value = $object->getLocalizedfields()->getLocalizedValue($field->getName(), $language);
            $collector->addItem($field->getName(), $value, $language);
        }

        $processed = [];

        // Pimcore provides further localized fields blocks as referencedFields.
        foreach ($property->getReferencedFields() as $child) {

            foreach ($child->getChildren() as $field) {

                if (in_array($field->getName(), $processed)) {
                    break;
                }

                $value = $object->getLocalizedfields()->getLocalizedValue($field->getName(), $language);
                $collector->addItem($field->getName(), $value, $language);

                $processed[] = $field->getName();
            }
        }
    }
}
