<?php

/**
 * Class ExportHandlerPassTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\Pimcore\ExportBundle\Compiler\ExportHandlerPass;
use Lifestyle\Pimcore\ExportBundle\Exception\InvalidExportHandlerException;
use Lifestyle\Pimcore\ExportBundle\Export\Processor;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class ExportHandlerPassTest
 * @package Tests\Lifestyle\Pimcore\ExportBundle\Compiler
 */
class ExportHandlerPassTest extends TestCase
{
    public function testBaseDefinitionNotFound()
    {
        $container = new ContainerBuilder();

        $pass = new ExportHandlerPass();
        $this->assertNull($pass->process($container));
    }

    public function testNoTaggedServices()
    {
        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.export.processor')
            ->setClass(Processor::class);

        $pass = new ExportHandlerPass();
        $pass->process($container);

        $processor = $container->get('lifestyle_pimcore_export.export.processor');
        $this->assertAttributeCount(0, 'handler', $processor);
    }

    public function testTaggedServicesWillBeAdded()
    {
        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.export.processor')
            ->setClass(Processor::class);

        $container
            ->register('handler.foo')
            ->setClass(ExportHandlerMock::class)
            ->addTag('lifestyle_pimcore_export.export_handler')
            ->setPublic(false);

        $container
            ->register('handler.bar')
            ->setClass(ExportHandlerMock::class)
            ->addTag('lifestyle_pimcore_export.export_handler')
            ->setPublic(false);

        $pass = new ExportHandlerPass();
        $pass->process($container);

        $processor = $container->get('lifestyle_pimcore_export.export.processor');
        $this->assertAttributeCount(2, 'handler', $processor);
    }

    public function testProcessWillThrowMissingInterfaceException()
    {
        $this->expectException(InvalidExportHandlerException::class);

        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.export.processor')
            ->setClass(Processor::class);

        $container
            ->register('handler.foo')
            ->addTag('lifestyle_pimcore_export.export_handler')
            ->setPublic(false);

        $pass = new ExportHandlerPass();
        $pass->process($container);
    }
}
