<?php

/**
 * Class Manager
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use JMS\Serializer\SerializerBuilder;
use JMS\Serializer\SerializerInterface;
use Psr\Log\LoggerInterface;
use Swoox\Api\Model\Request\Index\Swoox\NameFieldList;
use Lifestyle\Pimcore\ExportBundle\Mapping\Processor;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class Manager
 *
 * @package Lifestyle\Pimcore\ExportBundle\Api
 */
class Manager
{
    /**
     * @var array
     */
    private $properties = [];

    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var Processor
     */
    private $mappingProcessor;

    /**
     * Manager constructor.
     *
     * @param ContainerInterface $container
     * @param Processor $mappingProcessor
     */
    public function __construct(ContainerInterface $container, Processor $mappingProcessor)
    {
        $this->container = $container;
        $this->mappingProcessor = $mappingProcessor;
    }

    /**
     * getMappingProcessor
     *
     * @return Processor
     */
    public function getMappingProcessor()
    {
        return $this->mappingProcessor;
    }

    /**
     * getNameFieldList
     *
     * @param $name
     * @param $value
     * @param $valueClean
     *
     * @return NameFieldList
     */
    public function getNameFieldList($name, $value, $valueClean)
    {
        return (new NameFieldList())
            ->setName($name)
            ->setValue($value)
            ->setValueClean($valueClean);
    }

    /**
     * @return SerializerInterface
     */
    public function serializer()
    {
        if (!isset($this->properties[__FUNCTION__])) {
            $this->properties[__FUNCTION__] = SerializerBuilder::create()->build();
        }
        return $this->properties[__FUNCTION__];
    }

    /**
     * @return ClientInterface
     */
    public function client()
    {
        if (!isset($this->properties[__FUNCTION__])) {
            $this->properties[__FUNCTION__] = new Client();
        }
        return $this->properties[__FUNCTION__];
    }

    /**
     * logger
     *
     * @return LoggerInterface
     */
    public function logger()
    {
        return $this->container->get('pimcore.app_logger');
    }
}
