<?php

/**
 * Class ExportHandlerPass
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\Pimcore\ExportBundle\Exception\InvalidExportHandlerException;
use Lifestyle\Pimcore\ExportBundle\Export\HandlerInterface;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class ExportHandlerPass
 * @package Lifestyle\Pimcore\ExportBundle\Compiler
 */
class ExportHandlerPass implements CompilerPassInterface
{
    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        $this->addExportHandler($container);
    }

    /**
     * @param ContainerBuilder $container
     * @throws InvalidExportHandlerException
     */
    private function addExportHandler(ContainerBuilder $container)
    {
        if (!$container->has('lifestyle_pimcore_export.export.processor')) {
            return;
        }

        $definition = $container->findDefinition(
            'lifestyle_pimcore_export.export.processor'
        );

        $taggedServices = $container->findTaggedServiceIds(
            'lifestyle_pimcore_export.export_handler'
        );

        foreach ($taggedServices as $id => $tags) {
            $serviceDefinition = $container->findDefinition($id);
            if (!is_subclass_of($serviceDefinition->getClass(), HandlerInterface::class)) {
                throw new InvalidExportHandlerException(
                    sprintf("Export handler %s must implement interface %s", $serviceDefinition->getClass(), HandlerInterface::class)
                );
            }

            $definition->addMethodCall(
                'addHandler',
                array(new Reference($id))
            );
        }
    }
}
