<?php

/**
 * Class ObjectMapperPass
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\Pimcore\ExportBundle\Exception\InvalidObjectMapperException;
use Lifestyle\Pimcore\ExportBundle\ObjectMapper\MapperInterface;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class ObjectMapperPass
 * @package Lifestyle\Pimcore\ExportBundle\Compiler
 */
class ObjectMapperPass implements CompilerPassInterface
{
    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        $this->addObjectMappers($container);
    }

    /**
     * @param ContainerBuilder $container
     * @throws InvalidObjectMapperException
     */
    private function addObjectMappers(ContainerBuilder $container)
    {
        if (!$container->has('lifestyle_pimcore_export.object_mapper.handler')) {
            return;
        }

        $definition = $container->findDefinition(
            'lifestyle_pimcore_export.object_mapper.handler'
        );

        $taggedServices = $container->findTaggedServiceIds(
            'lifestyle_pimcore_export.object_mapper'
        );

        foreach ($taggedServices as $id => $tags) {
            $serviceDefinition = $container->findDefinition($id);
            if (!is_subclass_of($serviceDefinition->getClass(), MapperInterface::class)) {
                throw new InvalidObjectMapperException(
                    sprintf("Object mapper %s must implement interface %s", $serviceDefinition->getClass(), MapperInterface::class)
                );
            }

            $definition->addMethodCall(
                'addObjectMapper',
                array(new Reference($id))
            );
        }
    }
}
