<?php

/**
 * Class DataCollector
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector;

/**
 * Class DataCollector
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector
 */
class DataCollector implements DataCollectorInterface
{
    /**
     * @var DataCollectorItemInterface[]
     */
    private $items = [];

    /**
     * @param string $key
     * @param mixed $value
     * @param string|null $locale
     */
    public function addItem($key, $value, $locale = null)
    {
        if (!$this->hasItem($key, $locale)) {
            $this->items[] = new DataCollectorItem($key, $value, $locale);
        }
    }

    /**
     * @param $key
     * @param null $locale
     * @return bool
     */
    public function hasItem($key, $locale = null)
    {
        return null !== $this->getItem($key, $locale);
    }

    /**
     * @param string $key
     * @param string|null $locale
     * @return DataCollectorItemInterface|null
     */
    public function getItem($key, $locale = null)
    {
        foreach ($this->items as $item) {
            if ($key === $item->getKey()) {
                if (null === $locale) {
                    return $item;
                }
                if ($locale === $item->getLocale()) {
                    return $item;
                }
            }
        }

        return null;
    }

    /**
     * @param string $key
     * @param string|null $locale
     * @return mixed|null
     */
    public function getItemValue($key, $locale = null)
    {
        if (null !== ($item = $this->getItem($key, $locale))) {
            return $item->getValue();
        }

        return null;
    }

    /**
     * @param string|null $locale
     * @return DataCollectorItemInterface[]
     */
    public function getItems($locale = null)
    {
        if (null === $locale) {
            return $this->items;
        }

        $localeItems = [];

        foreach ($this->items as $item) {
            if ($locale === $item->getLocale()) {
                $localeItems[] = $item;
            }
        }

        return $localeItems;
    }

    /**
     * @return array
     */
    public function getCollectedLocales()
    {
        $locales = [];

        foreach ($this->items as $item) {
            if ($item->hasLocale()) {
                $locales[] = $item->getLocale();
            }
        }

        return array_unique($locales);
    }
}
