<?php

/**
 * Class ClassificationStoreHandler
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Handler;

use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Classificationstore;
use Pimcore\Model\DataObject\Classificationstore\KeyConfig;
use Pimcore\Model\DataObject\Concrete;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;

/**
 * Class ClassificationStoreHandler
 *
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Handler
 */
class ClassificationStoreHandler implements HandlerInterface
{
    /**
     * handle
     *
     * @param Data $property
     *
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof Classificationstore;
    }

    /**
     * handles
     *
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $classificationStore = $object->getValueForFieldName($property->getName());

        $attributes = [];
        foreach ($classificationStore->getItems() as $groupId => $group) {
            foreach ($group as $keyId => $value) {
                $value = $classificationStore->getLocalizedKeyValue($groupId, $keyId, $language);
                if (is_array($value)) {
                    $value = implode(' , ', $value);
                }

                $attributes[KeyConfig::getById($keyId)->getName()] = $value;
            }
        }

        foreach ($attributes as $attributeName => $attributeValue) {
            $collector->addItem($attributeName, $attributeValue, $language);
        }
    }
}
