<?php

/**
 * Class Processor
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping;

use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;

/**
 * Class Processor
 *
 * @package Lifestyle\Pimcore\ExportBundle\Mapping
 */
class Processor
{
    /**
     * @var Context
     */
    private $context;

    /**
     * Processor constructor.
     *
     * @param Context $context
     * @internal param $apiManager
     */
    public function __construct(Context $context)
    {
        $this->context = $context;
    }

    /**
     * handle
     *
     * @param DataCollectorInterface $collector
     * @param $object
     * @param $property
     * @param $language
     */
    public function handle(DataCollectorInterface $collector, $object, $property, $language)
    {
        $this->context->handle($collector, $object, $property, $language);
    }
}
