<?php

/**
 * Class Handler
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\ObjectMapper;

use Lifestyle\Pimcore\ExportBundle\Export\Processor;
use Pimcore\Event\Model\DataObjectEvent;
use Pimcore\Model\DataObject\Concrete;
use Psr\Log\LoggerInterface;

/**
 * Class Handler
 *
 * @package Lifestyle\Pimcore\ExportBundle\ObjectMapper
 */
class Handler
{
    /**
     * @var MapperInterface[]|array
     */
    private $availableObjectMapper = [];

    /**
     * @var Processor
     */
    private $exportProcessor;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * Handler constructor.
     *
     * @param Processor $exportProcessor
     * @param LoggerInterface $logger
     */
    public function __construct(Processor $exportProcessor, LoggerInterface $logger)
    {
        $this->exportProcessor = $exportProcessor;
        $this->logger = $logger;
    }

    /**
     * @param MapperInterface $objectMapper
     */
    public function addObjectMapper(MapperInterface $objectMapper)
    {
        $this->availableObjectMapper[] = $objectMapper;
    }

    /**
     * update
     *
     * @param DataObjectEvent $event
     */
    public function update(DataObjectEvent $event)
    {
        if (!$event->hasArgument('saveVersionOnly') || $event->getArgument('saveVersionOnly') !== true) {
            /**
             * @var Concrete $object
             */
            $object = $event->getObject();

            /**
             * check for save version only!
             */
            foreach ($this->availableObjectMapper as $mapper) {
                if ($mapper->applicable($object)) {
                    $collector = $mapper->getUpdateDataCollector($object);

                    if (!$object->isPublished()) {
                        $collector = $mapper->getDeleteDataCollector($object);
                        $this->exportProcessor->delete($collector);
                    } else {
                        $this->exportProcessor->createOrUpdate($collector);
                    }

                    $this->logger->debug(print_r($collector, true));
                }
            }
        }
    }

    /**
     * @param DataObjectEvent $event
     */
    public function delete(DataObjectEvent $event)
    {
        if (!$event->hasArgument('saveVersionOnly') || $event->getArgument('saveVersionOnly') !== true) {
            /**
             * @var Concrete $object
             */
            $object = $event->getObject();

            /**
             * check for save version only!
             */
            foreach ($this->availableObjectMapper as $mapper) {
                if ($mapper->applicable($object)) {
                    $collector = $mapper->getDeleteDataCollector($object);
                    $this->exportProcessor->delete($collector);

                    $this->logger->debug(print_r($collector, true));
                }
            }
        }
    }
}
