<?php

/**
 * Class FieldMapperPass
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\Pimcore\ExportBundle\Exception\InvalidFieldMapperException;
use Lifestyle\Pimcore\ExportBundle\Mapping\Field\FieldMapperInterface;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class FieldMapperPass
 * @package Lifestyle\Pimcore\ExportBundle\Compiler
 */
class FieldMapperPass implements CompilerPassInterface
{
    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        $this->addMappingHandler($container);
    }

    /**
     * @param ContainerBuilder $container
     * @throws InvalidFieldMapperException
     */
    private function addMappingHandler(ContainerBuilder $container)
    {
        if (!$container->has('lifestyle_pimcore_export.mapping.field.field_mapper_context')) {
            return;
        }

        $definition = $container->findDefinition(
            'lifestyle_pimcore_export.mapping.field.field_mapper_context'
        );

        $taggedServices = $container->findTaggedServiceIds(
            'lifestyle_pimcore_export.field_mapper'
        );

        foreach ($taggedServices as $id => $tags) {
            $serviceDefinition = $container->findDefinition($id);
            if (!is_subclass_of($serviceDefinition->getClass(), FieldMapperInterface::class)) {
                throw new InvalidFieldMapperException(
                    sprintf("Field mapper %s must implement interface %s", $serviceDefinition->getClass(), FieldMapperInterface::class)
                );
            }

            $definition->addMethodCall(
                'addHandler',
                array(new Reference($id))
            );
        }
    }
}
