<?php

/**
 * Class Processor
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;

/**
 * Class Processor
 * @package Lifestyle\Pimcore\ExportBundle\Export
 */
class Processor
{
    /**
     * @var HandlerInterface[]|array
     */
    private $handler = [];

    /**
     * @param HandlerInterface $handler
     */
    public function addHandler(HandlerInterface $handler)
    {
        $this->handler[] = $handler;
    }

    /**
     * @param DataCollectorInterface $collector
     */
    public function createOrUpdate(DataCollectorInterface $collector)
    {
        foreach ($this->handler as $handler) {
            if ($handler->isResponsible($collector)) {
                $handler->createOrUpdate($collector);
            }
        }
    }

    /**
     * @param DataCollectorInterface $collector
     */
    public function delete(DataCollectorInterface $collector)
    {
        foreach ($this->handler as $handler) {
            if ($handler->isResponsible($collector)) {
                $handler->delete($collector);
            }
        }
    }
}
