<?php

/**
 * Interface DataCollectorItemInterface
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector;

/**
 * Interface DataCollectorItemInterface
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector
 */
interface DataCollectorItemInterface
{
    /**
     * @return string
     */
    public function getKey();

    /**
     * @param mixed $value
     */
    public function setValue($value);

    /**
     * @return mixed
     */
    public function getValue();

    /**
     * @param string $locale
     */
    public function setLocale($locale);

    /**
     * @return string
     */
    public function getLocale();

    /**
     * @return bool
     */
    public function hasLocale();
}
