<?php

/**
 * Class NumberFieldMapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Numeric;
use Pimcore\Model\DataObject\Concrete;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;

/**
 * Class NumberFieldMapper
 *
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class NumberFieldMapper implements FieldMapperInterface
{
    /**
     * handle
     *
     * @param Data $property
     *
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof Numeric;
    }

    /**
     * handles
     *
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $collector->addItem($property->getName(), $object->getValueForFieldName($property->getName()));
    }
}
