<?php

/**
 * Class DefaultMapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Object;

use Lifestyle\Pimcore\ExportBundle\Mapping\Objects\MappingProcessor;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;

/**
 * Class DefaultMapper
 *
 * @package Lifestyle\Pimcore\ExportBundle\Mapper
 */
class DefaultMapper implements MapperInterface
{
    /**
     * @var MappingProcessor
     */
    private $mappingProcessor;

    /**
     * DefaultMapper constructor.
     * @param MappingProcessor $mappingProcessor
     */
    public function __construct(MappingProcessor $mappingProcessor)
    {
        $this->mappingProcessor = $mappingProcessor;
    }

    /**
     * @param $object
     * @return bool
     */
    public function applicable($object)
    {
        // just map if an object is given
        return null !== $object;
    }

    /**
     * @param \Pimcore\Model\DataObject\Product $object
     * @return DataCollectorInterface
     */
    public function getUpdateDataCollector($object)
    {
        return $this->mappingProcessor->mapEverythingFromObject($object);
    }

    /**
     * @param \Pimcore\Model\DataObject\Product $object
     * @return DataCollectorInterface
     */
    public function getDeleteDataCollector($object)
    {
        return $this->mappingProcessor->mapBaseFromObject($object);
    }
}
