<?php

/**
 * Class MappingProcessor
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Objects;

use Lifestyle\Pimcore\ExportBundle\Mapping\Field\FieldMapperProcessor;
use Pimcore\Config;
use Pimcore\Model\DataObject\AbstractObject;
use Pimcore\Model\DataObject\Concrete;
use Lifestyle\Pimcore\ExportBundle\Exception\NoHandlerException;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollector;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;

/**
 * Class MappingProcessor
 *
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Objects
 */
class MappingProcessor
{
    /**
     * @var FieldMapperProcessor
     */
    private $fieldMapperProcessor;

    /**
     * MappingProcessor constructor.
     * @param FieldMapperProcessor $fieldMapperProcessor
     */
    public function __construct(FieldMapperProcessor $fieldMapperProcessor)
    {
        $this->fieldMapperProcessor = $fieldMapperProcessor;
    }

    /**
     * @param AbstractObject $object
     * @return DataCollectorInterface
     */
    public function mapEverythingFromObject($object)
    {
        $config = Config::getSystemConfig();
        $languages = explode(',', $config->general->validLanguages);

        $collector = $this->mapBaseFromObject($object);

        foreach ($languages as $lang) {

            /**
             * @var \Pimcore\Model\DataObject\ClassDefinition\Data[] $property
             */
            foreach ($object->getClass()->getFieldDefinitions() as $property) {
                try {
                    $this->fieldMapperProcessor->handle($collector, $object, $property, $lang);
                } catch (NoHandlerException $nhe) {
                    // $this->apiManager;
                }
            }
        }

        return $collector;
    }

    /**
     * @param \Pimcore\Model\DataObject\Concrete $object
     * @return DataCollector
     */
    public function mapBaseFromObject($object)
    {
        $collector = new DataCollector();
        $collector->addItem('id', $object->getId());
        $collector->addItem('className', $object->getClassName());

        if (null !== ($parent = $this->getNextParentForInheritance($object, 'Product'))) {
            $collector->addItem('parentId', $parent->getId());
            $collector->addItem('parentClassName', $parent->getClassName());
        }

        $collector->addItem('type', $object->getType());

        return $collector;
    }

    /**
     * @param Concrete $object
     * @param string $parentClass
     * @return AbstractObject|null
     */
    public function getNextParentForInheritance(Concrete $object, $parentClass)
    {
        if ($object instanceof AbstractObject) {
            $parent = $object->getParent();
            while ($parent && $parent->getType() == 'folder') {
                $parent = $parent->getParent();
            }

            if ($parent && ($parent->getType() == 'object' || $parent->getType() == 'variant')) {
                if ($parent->getClassName() == $parentClass) {
                    return $parent;
                }
            }
        }

        return null;
    }
}
