<?php

/**
 * Class FieldMapperPassTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\Pimcore\ExportBundle\Compiler\FieldMapperPass;
use Lifestyle\Pimcore\ExportBundle\Exception\InvalidFieldMapperException;
use Lifestyle\Pimcore\ExportBundle\Mapping\Field\FieldMapperContext;
use Lifestyle\Pimcore\ExportBundle\Mapping\Field\FieldMapperInterface;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class FieldMapperPassTest
 * @package Tests\Lifestyle\Pimcore\ExportBundle\Compiler
 */
class FieldMapperPassTest extends TestCase
{
    public function testBaseDefinitionNotFound()
    {
        $container = new ContainerBuilder();

        $pass = new FieldMapperPass();
        $this->assertNull($pass->process($container));
    }

    public function testNoTaggedServices()
    {
        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.mapping.field.field_mapper_context')
            ->setClass(FieldMapperContext::class);

        $pass = new FieldMapperPass();
        $pass->process($container);

        $context = $container->get('lifestyle_pimcore_export.mapping.field.field_mapper_context');
        $this->assertAttributeCount(0, 'handlers', $context);
    }

    public function testTaggedServicesWillBeAdded()
    {
        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.mapping.field.field_mapper_context')
            ->setClass(FieldMapperContext::class);

        $container
            ->register('handler.foo')
            ->setClass($this->getMockBuilder(FieldMapperInterface::class)->getMock())
            ->addTag('lifestyle_pimcore_export.field_mapper')
            ->setPublic(false);

        $container
            ->register('handler.bar')
            ->setClass($this->getMockBuilder(FieldMapperInterface::class)->getMock())
            ->addTag('lifestyle_pimcore_export.field_mapper')
            ->setPublic(false);

        $pass = new FieldMapperPass();
        $pass->process($container);

        $context = $container->get('lifestyle_pimcore_export.mapping.field.field_mapper_context');

        $reflector = new \ReflectionClass($context);
        $property = $reflector->getProperty('handlers');
        $property->setAccessible(true);

        foreach ($property->getValue($context) as $priority => $handlers) {

            $this->assertCount(2, $handlers);

            foreach ($handlers as $handler) {
                $this->assertTrue(is_object($handler));
            }
        }
    }

    public function testProcessWillThrowMissingInterfaceException()
    {
        $this->expectException(InvalidFieldMapperException::class);

        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.mapping.field.field_mapper_context')
            ->setClass(FieldMapperContext::class);

        $container
            ->register('handler.foo')
            ->addTag('lifestyle_pimcore_export.field_mapper')
            ->setPublic(false);

        $pass = new FieldMapperPass();
        $pass->process($container);
    }
}
