<?php

/**
 * Class ObjectMapperPassTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\Pimcore\ExportBundle\Compiler\ObjectMapperPass;
use Lifestyle\Pimcore\ExportBundle\Exception\InvalidObjectMapperException;
use Lifestyle\Pimcore\ExportBundle\Export\Processor;
use Lifestyle\Pimcore\ExportBundle\Mapping\Object\Handler;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class ObjectMapperPassTest
 * @package Tests\Lifestyle\Pimcore\ExportBundle\Compiler
 */
class ObjectMapperPassTest extends TestCase
{
    public function testBaseDefinitionNotFound()
    {
        $container = new ContainerBuilder();

        $pass = new ObjectMapperPass();
        $this->assertNull($pass->process($container));
    }

    public function testNoTaggedServices()
    {
        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.mapping.object.handler')
            ->setArguments([$this->getMockBuilder(Processor::class)->disableOriginalConstructor()->getMock(), $this->getMockBuilder(LoggerInterface::class)->getMock()])
            ->setClass(Handler::class);

        $pass = new ObjectMapperPass();
        $pass->process($container);

        $objectMapperHandler = $container->get('lifestyle_pimcore_export.mapping.object.handler');
        $this->assertAttributeCount(0, 'availableObjectMapper', $objectMapperHandler);
    }

    public function testTaggedServicesWillBeAdded()
    {
        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.mapping.object.handler')
            ->setArguments([$this->getMockBuilder(Processor::class)->disableOriginalConstructor()->getMock(), $this->getMockBuilder(LoggerInterface::class)->getMock()])
            ->setClass(Handler::class);

        $container
            ->register('mapper.foo')
            ->setClass(ObjectMapperMock::class)
            ->addTag('lifestyle_pimcore_export.object_mapper')
            ->setPublic(false);

        $container
            ->register('mapper.bar')
            ->setClass(ObjectMapperMock::class)
            ->addTag('lifestyle_pimcore_export.object_mapper')
            ->setPublic(false);

        $pass = new ObjectMapperPass();
        $pass->process($container);

        $objectMapperHandler = $container->get('lifestyle_pimcore_export.mapping.object.handler');

        $reflector = new \ReflectionClass($objectMapperHandler);
        $property = $reflector->getProperty('availableObjectMapper');
        $property->setAccessible(true);

        $this->assertCount(2, $property->getValue($objectMapperHandler));

        foreach ($property->getValue($objectMapperHandler) as $handler) {
            $this->assertInstanceOf(ObjectMapperMock::class, $handler);
        }
    }

    public function testProcessWillThrowMissingInterfaceException()
    {
        $this->expectException(InvalidObjectMapperException::class);

        $container = new ContainerBuilder();

        $container
            ->register('lifestyle_pimcore_export.mapping.object.handler')
            ->setArguments([$this->getMockBuilder(Processor::class)->disableOriginalConstructor()->getMock(), $this->getMockBuilder(LoggerInterface::class)->getMock()])
            ->setClass(Handler::class);

        $container
            ->register('mapper.foo')
            ->addTag('lifestyle_pimcore_export.object_mapper')
            ->setPublic(false);

        $pass = new ObjectMapperPass();
        $pass->process($container);
    }
}
