<?php

/**
 * Class LifestylePimcoreExportBundle
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle;

use Lifestyle\Pimcore\ExportBundle\Compiler\ExportHandlerPass;
use Pimcore\Extension\Bundle\AbstractPimcoreBundle;
use Lifestyle\Pimcore\ExportBundle\Compiler\FieldMapperPass;
use Lifestyle\Pimcore\ExportBundle\Compiler\ObjectMapperPass;
use Pimcore\Extension\Bundle\Traits\PackageVersionTrait;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class LifestylePimcoreExportBundle
 *
 * @package Lifestyle\Pimcore\ExportBundle
 */
class LifestylePimcoreExportBundle extends AbstractPimcoreBundle
{
    use PackageVersionTrait;

    public function build(ContainerBuilder $container)
    {
        $container->addCompilerPass(new FieldMapperPass());
        $container->addCompilerPass(new ObjectMapperPass());
        $container->addCompilerPass(new ExportHandlerPass());
    }

    /**
     * Returns the composer package name used to resolve the version
     *
     * @return string
     */
    protected function getComposerPackageName()
    {
        return 'lifestyle/pimcore-export';
    }

    /**
     * getDescription
     *
     * @return string
     */
    public function getDescription()
    {
        return 'Object data mapping and controlling of the export';
    }
}
