<?php

/**
 * Class ObjectMapperMock
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\DataCollector\DataCollector;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\ExportBundle\Mapping\Object\MapperInterface;

/**
 * Class ObjectMapperMock
 * @package Tests\Lifestyle\Pimcore\ExportBundle\Compiler
 */
class ObjectMapperMock implements MapperInterface
{
    /**
     * @var string
     */
    public $priority;

    /**
     * Helper function for priority assertions.
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * @param $object
     * @return bool
     */
    public function applicable($object)
    {
        return true;
    }

    /**
     * @param $object
     * @return DataCollectorInterface
     */
    public function getUpdateDataCollector($object)
    {
        return new DataCollector();
    }

    /**
     * @param $object
     * @return DataCollectorInterface
     */
    public function getDeleteDataCollector($object)
    {
        return new DataCollector();
    }
}
