<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Lifestyle\DataCollector\DataCollectorInterface;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\Concrete;
use Psr\Log\LoggerInterface;

/**
 * Class LoggerNoFieldMapper
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class LoggerNoFieldMapper implements FieldMapperInterface
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * Is the handler capable of handling this input
     *
     * @param Data $property
     *
     * @return boolean
     */
    public function handles(Data $property)
    {
        return true;
    }

    /**
     * Execute actual handling of given input
     *
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $this->logger->warning(sprintf(
                'No field mapper found for property %s with class %s',
                $property->getName(),
                get_class($property)
            )
        );
    }
}
