<?php

/**
 * Class ObjectMapperPass
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\Pimcore\ExportBundle\Exception\InvalidObjectMapperException;
use Lifestyle\Pimcore\ExportBundle\Mapping\Object\MapperInterface;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class ObjectMapperPass
 * @package Lifestyle\Pimcore\ExportBundle\Compiler
 */
class ObjectMapperPass implements CompilerPassInterface
{
    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        $this->addObjectMappers($container);
    }

    /**
     * @param ContainerBuilder $container
     * @throws InvalidObjectMapperException
     */
    private function addObjectMappers(ContainerBuilder $container)
    {
        if (!$container->has('lifestyle_pimcore_export.mapping.object.handler')) {
            return;
        }

        $definition = $container->findDefinition(
            'lifestyle_pimcore_export.mapping.object.handler'
        );

        $taggedServices = $container->findTaggedServiceIds(
            'lifestyle_pimcore_export.object_mapper'
        );

        $services = [];
        foreach ($taggedServices as $id => $attributes) {
            $serviceDefinition = $container->findDefinition($id);
            if (!is_subclass_of($serviceDefinition->getClass(), MapperInterface::class)) {
                throw new InvalidObjectMapperException(
                    sprintf("Object mapper %s must implement interface %s", $serviceDefinition->getClass(), MapperInterface::class)
                );
            }

            $priority = isset($attributes[0]['priority']) ? $attributes[0]['priority'] : 0;
            $services[$priority][] = new Reference($id);
        }

        if (count($services) <= 0) {
            return;
        }

        krsort($services);
        $services = call_user_func_array('array_merge', $services);

        foreach ($services as $service) {
            $definition->addMethodCall(
                'addObjectMapper',
                array($service)
            );
        }
    }
}
