<?php

/**
 * Class ProcessorTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\ExportBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Export\HandlerInterface;
use Lifestyle\Pimcore\ExportBundle\Export\Processor;
use Lifestyle\DataCollector\DataCollector;
use PHPUnit\Framework\TestCase;

/**
 * Class ProcessorTest
 * @package Tests\Lifestyle\Pimcore\ExportBundle\Export
 */
class ProcessorTest extends TestCase
{
    public function testProcessorAddHandler()
    {
        $processor = new Processor();

        $randomUnsignedInt = rand(2, 10);

        for ($count = 0; $count < $randomUnsignedInt; ++$count) {
            $processor->addHandler($this->getMockBuilder(HandlerInterface::class)->getMock());
        }

        $reflector = new \ReflectionClass($processor);
        $property = $reflector->getProperty('handler');
        $property->setAccessible(true);

        $this->assertCount($randomUnsignedInt, $property->getValue($processor));
    }

    public function testProcessorCreateOrUpdate()
    {
        $responsibleHandler = $this->getMockBuilder(HandlerInterface::class)
            ->setMethods([])
            ->getMock();

        $responsibleHandler->expects($this->once())
            ->method('isResponsible')
            ->willReturn(true);

        $responsibleHandler->expects($this->once())
            ->method('publish');

        $otherHandler = $this->getMockBuilder(HandlerInterface::class)
            ->setMethods([])
            ->getMock();

        $otherHandler->expects($this->once())
            ->method('isResponsible')
            ->willReturn(false);

        $otherHandler->expects($this->never())
            ->method('publish');


        $processor = new Processor();
        $processor->addHandler($responsibleHandler);
        $processor->addHandler($otherHandler);

        $processor->createOrUpdate(new DataCollector());
    }

    public function testProcessorDelete()
    {
        $responsibleHandler = $this->getMockBuilder(HandlerInterface::class)
            ->setMethods([])
            ->getMock();

        $responsibleHandler->expects($this->once())
            ->method('isResponsible')
            ->willReturn(true);

        $responsibleHandler->expects($this->once())
            ->method('unpublish');

        $otherHandler = $this->getMockBuilder(HandlerInterface::class)
            ->setMethods([])
            ->getMock();

        $otherHandler->expects($this->once())
            ->method('isResponsible')
            ->willReturn(false);

        $otherHandler->expects($this->never())
            ->method('unpublish');


        $processor = new Processor();
        $processor->addHandler($responsibleHandler);
        $processor->addHandler($otherHandler);

        $processor->delete(new DataCollector());
    }
}
