<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Asset;

use Lifestyle\Pimcore\ExportBundle\Export\Processor;
use Pimcore\Model\Asset;
use Psr\Log\LoggerInterface;

/**
 * Class Handler
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Asset
 */
class Handler
{
    /**
     * @var Processor
     */
    private $exportProcessor;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var array MapperInterface[][]
     */
    private $assetMappers = [];

    /**
     * Handler constructor.
     * @param Processor $exportProcessor
     * @param LoggerInterface $logger
     */
    public function __construct(Processor $exportProcessor, LoggerInterface $logger)
    {
        $this->exportProcessor = $exportProcessor;
        $this->logger = $logger;
    }

    /**
     * @param MapperInterface $mapper
     */
    public function addAssetMapper(MapperInterface $mapper, $priority)
    {
        $this->assetMappers[$priority][] = $mapper;
    }

    /**
     * @param Asset $asset
     * @throws \ReflectionException
     */
    public function update(Asset $asset)
    {
        foreach ($this->getMappers() as $mapper) {
            if (!$mapper->applicable($asset)) {
                continue;
            }

            $this->logger->debug(
                sprintf(
                    'Active Update Asset Mapper: %s',
                    (new \ReflectionClass($mapper))->getShortName()
                )
            );

            $collector = $mapper->getUpdateDataCollector($asset);
            $this->exportProcessor->createOrUpdate($collector);

            $this->logger->debug(print_r($collector, true));
            break;
        }
    }

    /**
     * @param Asset $asset
     * @throws \ReflectionException
     */
    public function delete(Asset $asset)
    {
        foreach ($this->getMappers() as $mapper) {
            if (!$mapper->applicable($asset)) {
                continue;
            }

            $this->logger->debug(
                sprintf(
                    'Active Delete Asset Mapper: %s',
                    (new \ReflectionClass($mapper))->getShortName()
                )
            );

            $collector = $mapper->getDeleteDataCollector($asset);
            $this->exportProcessor->delete($collector);

            $this->logger->debug(print_r($collector, true));
            break;
        }
    }

    /**
     * @return MapperInterface[]
     */
    private function getMappers()
    {
        $mappers = $this->assetMappers;
        krsort($mappers);
        return call_user_func_array('array_merge', $mappers);
    }
}
