<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Configuration;

use Pimcore\Config as PimcoreConfig;

/**
 * Class LocaleConfiguration
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Configuration
 */
class LocaleConfiguration
{
    /**
     * @var bool
     */
    private $enablePrimaryLanguages;

    /**
     * @var bool
     */
    private $usePrimaryLanguages;

    /**
     * @var array
     */
    private $primaryLanguages;

    /**
     * LocaleConfiguration constructor.
     * @param bool $enablePrimaryLanguages
     */
    public function __construct($enablePrimaryLanguages)
    {
        $this->enablePrimaryLanguages = (bool)$enablePrimaryLanguages;
    }

    /**
     * @return bool
     */
    public function usePrimaryLanguages()
    {
        if (null === $this->usePrimaryLanguages) {
            $this->usePrimaryLanguages =
                $this->enablePrimaryLanguages &&
                count($this->getPrimaryLanguages()) === count(array_unique($this->getPrimaryLanguages()));
        }

        return $this->usePrimaryLanguages;
    }

    /**
     * @return array
     */
    public function getPrimaryLanguages()
    {
        if (null === $this->primaryLanguages) {
            $this->primaryLanguages = array_map([\Locale::class, 'getPrimaryLanguage'], $this->getLanguages());
        }

        return $this->primaryLanguages;
    }

    /**
     * @return array
     */
    public function getLanguages()
    {
        return explode(',', PimcoreConfig::getSystemConfig()->general->validLanguages);
    }
}