<?php

/**
 * Interface HandlerInterface
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Export;

use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Interface HandlerInterface
 *
 * @package Lifestyle\Pimcore\ExportBundle\Export
 */
interface HandlerInterface
{
    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector);

    /**
     * @param DataCollectorInterface $collector
     */
    public function publish(DataCollectorInterface $collector);

    /**
     * @param DataCollectorInterface $collector
     */
    public function unpublish(DataCollectorInterface $collector);
}
