<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\ExportBundle\Exception\NoHandlerException;
use Pimcore\Model\DataObject\ClassDefinition\Data;

/**
 * Class FieldMapperProcessor
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class FieldMapperProcessor
{
    /**
     * @var FieldMapperContext
     */
    private $context;

    /**
     * @param FieldMapperContext $context
     * @internal param $apiManager
     */
    public function __construct(FieldMapperContext $context)
    {
        $this->context = $context;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param object $object
     * @param Data $property
     * @param string $language
     * @throws NoHandlerException
     */
    public function handle(DataCollectorInterface $collector, $object, Data $property, $language)
    {
        $this->context->handle($collector, $object, $property, $language);
    }
}
