<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\ExportBundle\Compiler;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\ExportBundle\Mapping\Field\FieldMapperInterface;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\Concrete;

/**
 * Class FieldMapperMock
 * @package Tests\Lifestyle\Pimcore\ExportBundle\Compiler
 */
class FieldMapperMock implements FieldMapperInterface
{
    /**
     * @var string
     */
    public $priority;

    /**
     * Helper function for priority assertions.
     */
    public function getPriority()
    {
        return $this->priority;
    }

    /**
     * @param Data $property
     * @return boolean
     */
    public function handles(Data $property)
    {
        return true;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {

    }
}
