<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Pimcore\Model\Asset;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\Concrete;
use Pimcore\Model\DataObject\ClassDefinition\Data\ManyToOneRelation;
use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Class ManyToOneRelationFieldMapper
 *
 * Replaces the HrefAssetFieldMapper
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class ManyToOneRelationFieldMapper implements FieldMapperInterface
{
    /**
     * @param Data $property
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof ManyToOneRelation;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $relation = $object->getValueForFieldName($property->getName());

        $collector->addItem($property->getName() . 'Id', $relation->getId());

        if ($relation instanceof Asset) {
            $collector->addItem($property->getName(), $relation->getFullPath());
        }
    }
}
