<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Objects;
use Pimcore\Model\DataObject\Concrete;
use Lifestyle\DataCollector\DataCollectorInterface;
use Pimcore\Model\Element\ValidationException;

/**
 * Class ObjectListFieldMapper
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class ObjectListFieldMapper implements FieldMapperInterface
{
    /**
     * @param Data $property
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof Objects;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     * @throws ValidationException
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        /** @var Concrete[] $objects */
        $objects = $object->getValueForFieldName($property->getName());
        if (empty($objects)) {
            return;
        }

        if (1 === count($objects)) {
            $this->validateAssociation($object, $objects[0]);
            $collector->addItem($property->getName(), $objects[0]->getId());
        }

        if (count($objects) > 1) {
            $objectIdList = [];

            foreach ($objects as $linkedObject) {
                $this->validateAssociation($object, $linkedObject);
                $objectIdList[] = $linkedObject->getId();
            }

            $collector->addItem($property->getName(), $objectIdList);
        }
    }

    /**
     * @param Concrete $baseObject
     * @param Concrete $linkedObject
     * @throws ValidationException
     */
    private function validateAssociation(Concrete $baseObject, Concrete $linkedObject)
    {
        if (!$baseObject->isPublished()) {
            // No validation for DELETE requests
            return;
        }

        if (!$linkedObject->isPublished()) {
            throw new ValidationException(
                sprintf(
                    "Object with ID %s is not published. Therefore it can not be linked!",
                    $linkedObject->getId()
                )
            );
        }
    }
}
