<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Checkbox;
use Pimcore\Model\DataObject\Concrete;
use Lifestyle\DataCollector\DataCollectorInterface;
use Symfony\Component\PropertyAccess\PropertyAccessorInterface;

/**
 * Class CheckboxFieldMapper
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class CheckboxFieldMapper implements FieldMapperInterface
{
    /**
     * @var PropertyAccessorInterface
     */
    private $propertyAccessor;

    /**
     * CheckboxFieldMapper constructor.
     * @param PropertyAccessorInterface $propertyAccessor
     */
    public function __construct(PropertyAccessorInterface $propertyAccessor)
    {
        $this->propertyAccessor = $propertyAccessor;
    }

    /**
     * @param Data $property
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof Checkbox;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $propertyName = $property->getName();
        $value = $this->propertyAccessor->getValue($object, $propertyName);
        if (null === $value && null !== ($parent = $object->getNextParentForInheritance())) {
            $value = $this->propertyAccessor->getValue($parent, $propertyName);
        }
        if (null !== $value) {
            $collector->addItem($property->getName(), (bool)$value);
        }
    }
}
