<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Listener;

use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportExceptionInterface;
use Lifestyle\Pimcore\ExportBundle\Mapping\Asset\Handler;
use Pimcore\Event\Model\AssetEvent;
use Pimcore\Model\Asset;
use Psr\Log\LoggerInterface;

/**
 * Class AssetLS
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Listener
 */
class AssetLS
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var Handler
     */
    private $assetMapper;

    /**
     * @var bool
     */
    private $enabled;

    /**
     * AssetLS constructor.
     * @param LoggerInterface $logger
     * @param Handler $assetMapper
     * @param bool $enabled
     */
    public function __construct(LoggerInterface $logger, Handler $assetMapper, bool $enabled)
    {
        $this->logger = $logger;
        $this->assetMapper = $assetMapper;
        $this->enabled = $enabled;
    }

    /**
     * @param AssetEvent $event
     */
    public function onPostUpdate(AssetEvent $event)
    {
        $asset = $event->getAsset();
        if (!$this->enabled || !$asset instanceof Asset) {
            return;
        }

        if ($event->hasArgument('saveVersionOnly') && true === $event->getArgument('saveVersionOnly')) {
            return;
        }

        try {
            $this->assetMapper->update($asset);
        } catch (PimcoreExportExceptionInterface $exception) {
            $this->logger->error($exception->getMessage());
        }
    }

    /**
     * @param AssetEvent $event
     */
    public function onPostDelete(AssetEvent $event)
    {
        $asset = $event->getAsset();
        if (!$this->enabled || !$asset instanceof Asset) {
            return;
        }

        try {
            $this->assetMapper->delete($asset);
        } catch (PimcoreExportExceptionInterface $exception) {
            $this->logger->error($exception->getMessage());
        }
    }
}
